#include <linux/cpumask.h>
#include <linux/completion.h>
#include <linux/kthread.h>
#include <linux/random.h>
#include <linux/sched.h>
#include <linux/version.h>

int smp_asm_set_master_key(void* data);


static DECLARE_COMPLETION(joiner);
int smp_loop_thread_wrapper(void* data)
{
     printk("Running...");
     int retval = smp_asm_set_master_key(data);
     printk("Done: %d",retval);

     WARN_ON(retval);
     complete(&joiner);
     do_exit(retval);
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 10, 104)
#include <linux/compiler.h>
#ifndef barrier_data
#define barrier_data(ptr) barrier()
#endif
static void memzero_explicit(void *s, size_t count)
{
     memset(s, 0, count);
     barrier_data(s);
}
#endif

void smp_master_key(void)
{
     uint8_t rbytes[16];
     int cpu;
     
     get_random_bytes(rbytes,16);
     for(cpu = cpumask_first(cpu_online_mask); cpu < nr_cpu_ids; cpu = cpumask_next(cpu,cpu_online_mask))
     {
          struct task_struct* thread;

          thread = kthread_create(smp_loop_thread_wrapper,rbytes,"amnesiacpu%d",cpu);
          kthread_bind(thread,cpu);

#ifdef INIT_COMPLETION
          INIT_COMPLETION(joiner);
#else
          reinit_completion(&joiner);
#endif

          wake_up_process(thread);
          wait_for_completion(&joiner);
     }

     memzero_explicit(rbytes,16);
}
